
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class ChromaticAberation:RDGraphCompositorEffect
  {
    public ChromaticAberation():base()
    {
      Initialize();
    }

    [Export]
    public Vector2 rShift = new Vector2( -0.001f, 0.0f );

    [Export]
    public Vector2 gShift = new Vector2( 0.0f, 0.0f );

    [Export]
    public Vector2 bShift = new Vector2( 0.001f, 0.0f );

        
    [Export]
    public float intensity = 0.5f;

    [Export]
    public float shiftAll = 0.5f;

    [Export]
    public float unshiftCenter = 16f;

    [Export]
    public int constantsInternalSize;


    CEG_ScreenColorTexure screenColorTexture;
    CEG_BufferTexture bufferTexture;    

    CEG_Copy copy;
    CEG_ChromaticAberation chromaticAberation;    

    void Initialize()
    { 
      screenColorTexture = new CEG_ScreenColorTexure( graph );
      bufferTexture = CEG_BufferTexture.ScreenSize( graph );

      copy = new CEG_Copy( graph );
      chromaticAberation = new CEG_ChromaticAberation( graph );


      graph.InitializeNodes();      

      copy.SetTextureSlotInputs( screenColorTexture, bufferTexture );
      chromaticAberation.SetTextureSlotInputs( copy.output, copy.input ); 


      graph.SetProcessOrder( 
        screenColorTexture, 
        bufferTexture, 
        copy, 
        chromaticAberation 
      );
    }
   

    protected override void ForAllViews()
    {

      chromaticAberation.constants.Set(

        rShift,
        gShift,
        bShift,
        intensity, 
        shiftAll, 
        unshiftCenter       
      );

      constantsInternalSize = chromaticAberation.constants.internalSize;
    }

   
  }
}