
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class DepthAOEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "DepthAO/DepthAOShader.glsl" );

    RDSampler sampler;

    [Export( PropertyHint.Range, "0,1") ]
    public float greyAmount;

    [Export( PropertyHint.Range, "0,1") ]
    public float depthAmount;

    [Export( PropertyHint.Range, "0,5") ]
    public float effectStrength = 1;

    [Export( PropertyHint.Range, "2,8") ]
    public float depthEdgeTreshold = 2f;

    [Export( PropertyHint.Range, "1,10") ]
    public float depthEdgeIntensity = 1f;

    [Export( PropertyHint.Range, "0,8") ]
    public float radius = 2f;

    [Export( PropertyHint.Range, "0.001,1") ]
    public float jump = 1f;

    [Export( PropertyHint.Range, "0,1") ]
    public float debugView = 0f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }

    protected override void OnInitialize()
    {
      base.OnInitialize();

      sampler = context.Sampler( RenderingDevice.SamplerFilter.Nearest, RenderingDevice.SamplerRepeatMode.ClampToEdge );
    }

    

    protected override void SetConstants()
    {     
      constants.Set(
        (Vector2)context.internalSize, 
        new Vector2( greyAmount, depthAmount ),
        effectStrength,
        depthEdgeTreshold / 100f,
        depthEdgeIntensity * 20f,
        radius,
        jump,
        debugView
      );
    }
    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();
      context.AssignScreenDepthTexture( sampler );

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}