
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract  partial class DepthAntiAliasingEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "DepthAntiAliasing/DepthAntiAliasingShader.glsl" );

    RDSampler sampler;

    [Export( PropertyHint.Range, "0,1") ]
    public float greyAmount;

    [Export( PropertyHint.Range, "0,1") ]
    public float depthAmount;

    [Export( PropertyHint.Range, "0,1") ]
    public float effectStrength = 1;

    [Export( PropertyHint.Range, "0,20") ]
    public float depthEdgeTreshold = 2f;

    [Export( PropertyHint.Range, "0,1") ]
    public float depthEdgeIntensity = 1f;

    [Export( PropertyHint.Range, "0,100") ]
    public float colorContrastTreshold = 2f;

    [Export( PropertyHint.Range, "0,1") ]
    public float colorContrastIntensity = 1f;

    [Export( PropertyHint.Range, "0,1") ]
    public float debugView = 0f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }

    protected override void OnInitialize()
    {
      base.OnInitialize();

      sampler = context.Sampler( RenderingDevice.SamplerFilter.Nearest, RenderingDevice.SamplerRepeatMode.ClampToEdge );
    }

    

    protected override void SetConstants()
    {     
      constants.Set(
        (Vector2)context.internalSize, 
        new Vector2( greyAmount, depthAmount ),
        effectStrength,
        depthEdgeTreshold / 100f,
        depthEdgeIntensity * 20f,
        colorContrastTreshold / 100f,
        colorContrastIntensity * 20f,
        debugView
      );
    }
    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();
      context.AssignScreenDepthTexture( sampler );

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}