
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class DepthViewEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "DepthView/DepthViewShader.glsl" );

    RDSampler sampler;

    [Export( PropertyHint.Range, "0,1") ]
    public float depthAmount = 1;

    [Export( PropertyHint.Range, "0.001,3") ]
    public float depthPower = 0.5f;

    [Export( PropertyHint.Range, "0,1") ]
    public float grayAmount = 0f;

    [Export( PropertyHint.Range, "0,1") ]
    public float mappedMinValue = 0f;

    [Export( PropertyHint.Range, "0,1") ]
    public float mappedMaxValue = 1f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }

    protected override void OnInitialize()
    {
      base.OnInitialize();

      sampler = context.Sampler( RenderingDevice.SamplerFilter.Nearest, RenderingDevice.SamplerRepeatMode.ClampToEdge );
    }

    protected override void SetConstants()
    {     
      constants.Set(
        depthAmount,
        depthPower,
        grayAmount,
        mappedMinValue,
        mappedMaxValue
      );
    }
    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();
      context.AssignScreenDepthTexture( sampler );

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}