
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class EnsureValidFloatsEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "EnsureValidFloats/EnsureValidFloats.glsl" );

    [Export( PropertyHint.Range, "-10,10")]
    public float clamping = 0f;


    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }


    protected override void SetConstants()
    {     
      constants.Set(
        clamping
      );
    }

    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();      

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}