#[compute]
#version 450

layout( local_size_x = 16, local_size_y = 16, local_size_z = 1 ) in;

layout( rgba16f, set = 0, binding = 0) 
uniform image2D color_image;

layout(push_constant, std430)
uniform Parameters
{
	vec2 raster_size;
	float amount;
  float method;

} parameters;


void main() 
{
	ivec2 uv   = ivec2( gl_GlobalInvocationID.xy );
	ivec2 size = ivec2( parameters.raster_size );

	if ( uv.x >= size.x || uv.y >= size.y ) 
  {
		return;  
	}

	vec4 color = imageLoad( color_image, uv );

	float gray = color.r * 0.2 + color.g * 0.7 + color.b * 0.1;
  float avg = ( color.r + color.g + color.b ) / 3.0;
   
  gray = mix( gray, avg, parameters.method );

	color.rgb = mix( color.rgb, vec3( gray ), parameters.amount );

	imageStore( color_image, uv, color );
}