
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class GreyScaleEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "GreyScale/GrayScaleShader.glsl" );

    [Export( PropertyHint.Range, "0,1" )]
    public float amount;
    
    [Export( PropertyHint.Range, "0,1" )]
    public float luminanceMethod;


    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }

    protected override void SetConstants()
    {     
      constants.Set(
        (Vector2)context.internalSize, 
        amount, 
        luminanceMethod 
      );
    }
    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}