
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class NormalViewEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "DepthView/NormalViewShader.glsl" );

    RDSampler sampler;

    [Export( PropertyHint.Range, "0,1") ]
    public float normalsAmount = 1;

    [Export( PropertyHint.Range, "0,1") ]
    public float grayAmount = 0f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }

    protected override void OnInitialize()
    {
      base.OnInitialize();

      sampler = context.Sampler( RenderingDevice.SamplerFilter.Nearest, RenderingDevice.SamplerRepeatMode.ClampToEdge );
    }

    protected override void SetConstants()
    {     
      constants.Set(
        normalsAmount,
        grayAmount
      );
    }
    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}