#[compute]
#version 450

layout( local_size_x = 8, local_size_y = 8, local_size_z = 1 ) in;

layout( rgba16f, set = 0, binding = 0) 
uniform image2D colorImage;

layout( set = 1, binding = 0) 
uniform sampler2D normalSampler;

layout( push_constant, std430 )
uniform Parameters
{
	float normalsAmount;
  float grayAmount;  

} parameters;

vec3 sampleNormal( ivec2 coord, ivec2 size ) 
{
  coord = clamp( coord, ivec2( 0 ), size - ivec2( 1 ) );

  vec2 uv = ( vec2( coord ) + 0.5 ) / size;
  return texture( normalSampler, uv ).xyz;
}

void main() 
{
	ivec2 uv   = ivec2( gl_GlobalInvocationID.xy );
	ivec2 size = imageSize( colorImage );

	if ( uv.x >= size.x || uv.y >= size.y ) 
  {
		return;
	}

	vec4 color = imageLoad( colorImage, uv );
  vec3 normal = sampleNormal( uv, size ); 

	float gray = color.r * 0.2 + color.g * 0.7 + color.b * 0.1;


  normal = mix( normal, normal * gray, parameters.grayAmount );

	color.rgb = normal;

	imageStore( colorImage, uv, color );
}