
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class PixelationEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "Pixelation/PixelationShader.glsl" );

    [Export]
    public float pixelSize = 1f;

    [Export]
    public float pixelSizePower = 1f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }

    protected override void SetConstants()
    {     
      constants.Set(
        (Vector2)context.internalSize, 
        Mathf.Pow( pixelSize, pixelSizePower )
      );
    }
    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}