
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class RadialBlurEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "RadialBlur/RadialBlurShader.glsl" );

    [Export]
    public Vector2 center = new Vector2( 0.5f, 0.5f );

    [Export]
    public float radius = 0.5f;

    [Export]
    public float intensity = 0.5f;

    [Export]
    public float samples = 16f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 32;
    }


    protected override void SetConstants()
    {     
      constants.Set(
        center, 
        radius, 
        intensity,
        samples,
        Vector2.Zero
      );
    }
    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}