
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class RadialBlur2:RDGraphCompositorEffect
  {
    public RadialBlur2():base()
    {
      Initialize();
    }

    [Export]
    public Vector2 center = new Vector2( 0.5f, 0.5f );

    [Export]
    public float radius = 0.01f;

    [Export]
    public float intensity =1f;

    [Export]
    public float samples = 8f;


    CEG_ScreenColorTexure screenColorTexture;
    CEG_BufferTexture bufferTexture;    

    CEG_Copy copy;
    CEG_RadialBlur radialBlur;    

    void Initialize()
    { 
      screenColorTexture = new CEG_ScreenColorTexure( graph );
      bufferTexture = CEG_BufferTexture.ScreenSize( graph );

      copy = new CEG_Copy( graph );
      radialBlur = new CEG_RadialBlur( graph );


      graph.InitializeNodes();      

      

      copy.SetTextureSlotInputs( screenColorTexture, bufferTexture );
      radialBlur.SetTextureSlotInputs( copy.output, copy.input ); 


      graph.SetProcessOrder( 
        screenColorTexture, bufferTexture, 
        copy, radialBlur 
      );
    }
   

    protected override void ForAllViews()
    {
      radialBlur.constants.Set(
        center, 
        radius, 
        intensity,
        samples,
        Vector2.Zero
      );
    }

   
  }
}