
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class RimEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "Rim/RimShader.glsl" );

    RDSampler sampler;


    [Export( PropertyHint.Range, "0,50") ]
    public float effectStrength = 1;

    [Export( PropertyHint.Range, "-10,10") ]
    public float rimOffsetX = 2f;

    [Export( PropertyHint.Range, "-10,10") ]
    public float rimOffsetY = 0f;

    [Export( PropertyHint.Range, "0.0001,1") ]
    public float minDepth = 0.001f;

    [Export( PropertyHint.Range, "0.01,500.0") ]
    public float depthScale = 1f;

    [Export( PropertyHint.Range, "-10,10.0") ]
    public float depthOffset = 1f;

    [Export( PropertyHint.Range, "1,1000") ]
    public float contrast = 1f;

    [Export( PropertyHint.Range, "0,1") ]
    public float debugView = 0f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostOpaque;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }

    protected override void OnInitialize()
    {
      base.OnInitialize();

      sampler = context.Sampler( RenderingDevice.SamplerFilter.Nearest, RenderingDevice.SamplerRepeatMode.ClampToEdge );
    }

    

    protected override void SetConstants()
    {     
      constants.Set(
        (Vector2)context.internalSize, 
        new Vector2( depthScale, depthOffset ),
        effectStrength,
        rimOffsetX,
        rimOffsetY,
        minDepth,
        contrast,
        debugView
      );
    }
    
    protected override void RenderView()
    {
      context.AssignScreenColorTexture();
      context.AssignScreenDepthTexture( sampler );

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}