
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class SharpenEffect:RDGraphCompositorEffect
  {
    public SharpenEffect():base()
    {
      Initialize();
    }

    [Export( PropertyHint.Range, "0,1")]
    public float amount = 1f;

    [Export( PropertyHint.Range, "0,1")]
    public float maxDifference = 0.5f;

    CEG_ScreenColorTexure screenColorTexture;
    CEG_BufferTexture bufferTexture;    

    CEG_Copy copy;
    RD_Sharpen sharpen;    

    void Initialize()
    { 
      screenColorTexture = new CEG_ScreenColorTexure( graph );
      bufferTexture = CEG_BufferTexture.ScreenSize( graph );

      copy = new CEG_Copy( graph );
      sharpen = new RD_Sharpen( graph );
      graph.InitializeNodes();

      copy.SetTextureSlotInputs( screenColorTexture, bufferTexture );
      sharpen.SetTextureSlotInputs( copy.output, copy.input );


      graph.SetProcessOrder(
        screenColorTexture, 
        bufferTexture, 
        copy,
        sharpen 
      );
      
    }
    
    protected override void ForAllViews()
    {
      sharpen.constants.Set(
       [ 
        amount,
        maxDifference 
       ]
      );
     
    }

   
  }
}