#[compute]
#version 450

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout(rgba16f, set = 0, binding = 0) 
uniform restrict image2D lastProcessedImage;

layout(rgba16f, set = 1, binding = 0) 
uniform restrict image2D currentImage;

layout( push_constant, std430 ) 
uniform Params  
{
  float amount;
  float smearing;
  float luma;
  float minBrightness;
  float saturate;
  float blur;
  float blurRange;

} params;

void main() 
{
	ivec2 currentPosition = ivec2( gl_GlobalInvocationID.xy );

	vec4 currentPixel = imageLoad( currentImage, currentPosition );  
  vec4 lastPixel = imageLoad( lastProcessedImage, currentPosition );

  int blurOffset = int( params.blurRange );
  vec4 top = imageLoad( lastProcessedImage, currentPosition + ivec2( 0, -blurOffset ) ); 
  vec4 left = imageLoad( lastProcessedImage, currentPosition + ivec2( -blurOffset, 0 ) ); 
  vec4 bottom = imageLoad( lastProcessedImage, currentPosition + ivec2( 0, blurOffset ) ); 
  vec4 right = imageLoad( lastProcessedImage, currentPosition + ivec2( blurOffset, 0 ) ); 
  
  vec4 blurred = ( top + left + bottom + right ) / 4.0;
  
  vec4 blurredLastPixel = mix( lastPixel, blurred, params.blur );

  float luminance = min( 1.0, length( vec3( lastPixel.r, lastPixel.g, lastPixel.b ) ) );
  float amount = ( luminance - params.minBrightness ) / ( 1.0 - params.minBrightness );
  amount = min( max( 0.0, amount * params.saturate ), 1.0 ) * params.smearing;
  amount = mix( 1.0, amount, params.luma );
  
  vec4 nextPixel = currentPixel + min( 1.0, amount * params.smearing ) * ( lastPixel - currentPixel );
  vec4 nextPixelBlurred = currentPixel + min( 1.0, amount * params.smearing ) * ( blurredLastPixel - currentPixel );
  

	imageStore( currentImage, currentPosition, mix( currentPixel, nextPixelBlurred, params.amount ) );
  imageStore( lastProcessedImage, currentPosition, nextPixel );
}
