
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class TemporalSmearEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "TemporalSmear/TemporalSmear.glsl" );

    [Export( PropertyHint.Range, "0,1")]
    public float amount = 1f;

    [Export( PropertyHint.Range, "0,600")]
    public float smearingFrames = 30;

    [Export( PropertyHint.Range, "0,1")]
    public float lumaAmount = 0.5f;

    [Export( PropertyHint.Range, "0,1")]
    public float lumaTreshold = 0.5f;

    [Export( PropertyHint.Range, "0,5")]
    public float lumaSaturate = 0.8f;

    [Export( PropertyHint.Range, "0,1")]
    public float blur = 0.5f;

    [Export( PropertyHint.Range, "1,30")]
    public float blurRange = 2f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }


    protected override void SetConstants()
    {     
      constants.Set(
        amount,
        1.0f - FrameSmoothing.ComputeCoefficient( 1f/60f, smearingFrames ),
        lumaAmount,
        lumaTreshold,
        lumaSaturate,
        blur,
        blurRange
      );
    }

    RDTexture _bufferTexture;
    
    protected override void RenderView()
    {
      _bufferTexture = RDTexture.EnsureScreenSizeTexture( _bufferTexture, context );
      
      context.AssignTexture( _bufferTexture );
      context.AssignScreenColorTexture();
      

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}