#[compute]
#version 450

#include "res://addons/rokojori_action_library/Runtime/Shading/Library/Validation.gdshaderinc"

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout(rgba16f, set = 0, binding = 0) 
uniform restrict image2D lastProcessedImage;

layout(rgba16f, set = 1, binding = 0) 
uniform restrict image2D currentImage;

layout( push_constant, std430 ) 
uniform Params  
{
  float amount;
  float smearing;

} params;

void main() 
{
	ivec2 currentPosition = ivec2( gl_GlobalInvocationID.xy );

	vec4 currentPixel = ensureValidVec4( imageLoad( currentImage, currentPosition ) );  
  vec4 lastPixel = ensureValidVec4( imageLoad( lastProcessedImage, currentPosition ) );   

  vec4 nextPixel = currentPixel + params.smearing * ( lastPixel - currentPixel );
  vec4 combinedPixel = mix( currentPixel, nextPixel, params.amount );
  

	imageStore( currentImage, currentPosition, ensureValidVec4( combinedPixel ) );
  imageStore( lastProcessedImage, currentPosition, ensureValidVec4( nextPixel ) );
}
