
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class TemporalSmearSimpleEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "TemporalSmearSimple/TemporalSmearSimple.glsl" );

    [Export( PropertyHint.Range, "0,1")]
    public float amount = 1f;

    [Export( PropertyHint.Range, "0,600")]
    public float smearingFrames = 30;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }


    protected override void SetConstants()
    {     
      constants.Set(
        amount,
        1.0f - FrameSmoothing.ComputeCoefficient( 1f/60f, smearingFrames )
      );
    }

    RDTexture _bufferTexture;
    
    protected override void RenderView()
    {
      _bufferTexture = RDTexture.EnsureScreenSizeTexture( _bufferTexture, context );
      
      context.AssignTexture( _bufferTexture );
      context.AssignScreenColorTexture();
      

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}