#[compute]
#version 450

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout(rgba16f, set = 0, binding = 0) 
uniform restrict image2D lastProcessedImage;

layout(rgba16f, set = 1, binding = 0) 
uniform restrict image2D lastProcessedImage2;

layout(rgba16f, set = 2, binding = 0) 
uniform restrict image2D currentImage;

layout( push_constant, std430 ) 
uniform Params  
{
  float amount;
  float smearing;
  float smearing2;

} params;

void main() 
{
	ivec2 currentPosition = ivec2( gl_GlobalInvocationID.xy );

	vec4 currentPixel = imageLoad( currentImage, currentPosition );  
  vec4 lastPixel = imageLoad( lastProcessedImage, currentPosition );
  vec4 acceleration = imageLoad( lastProcessedImage2, currentPosition );

  vec4 difference = currentPixel - lastPixel;
  acceleration = mix( acceleration, difference, params.smearing );

  vec4 nextAcceleration = mix( acceleration, vec4( 0, 0, 0, 0 ), pow( params.smearing, params.smearing2 ) );
  acceleration = mix( nextAcceleration, acceleration, params.smearing );

  vec4 nextPixel = mix( lastPixel, lastPixel + acceleration, params.smearing );
  

	imageStore( currentImage, currentPosition, mix( currentPixel, nextPixel, params.amount ) );
  imageStore( lastProcessedImage, currentPosition, nextPixel );
  imageStore( lastProcessedImage2, currentPosition, acceleration );
}
