
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class TemporalSmearWobblyEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "TemporalSmearWobbly/TemporalSmearWobbly.glsl" );

    [Export( PropertyHint.Range, "0,1")]
    public float amount = 1f;

    [Export( PropertyHint.Range, "0,1")]
    public float smearingFrames = 0.1f;

    [Export( PropertyHint.Range, "0,1")]
    public float wobblingCoefficient = 0.5f;

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }


    protected override void SetConstants()
    {     
      constants.Set(
        amount,
        // 1.0 - FrameSmoothing.ComputeCoefficient( 1f/60f, smearingFrames ),
        smearingFrames,
        wobblingCoefficient
      );
    }

    RDTexture _bufferTexture;
    RDTexture _bufferTexture2;

    protected override void RenderView()
    {
      _bufferTexture = RDTexture.EnsureScreenSizeTexture( _bufferTexture, context );
      _bufferTexture2 = RDTexture.EnsureScreenSizeTexture( _bufferTexture2, context );
      
      context.AssignTexture( _bufferTexture );
      context.AssignTexture( _bufferTexture2 );
      context.AssignScreenColorTexture();
      

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}