#[compute]
#version 450

layout( local_size_x = 8, local_size_y = 8, local_size_z = 1 ) in;

layout( rgba16, set = 0, binding = 0 ) 
uniform restrict readonly image2D inputImage;

layout( rgba16, set = 1, binding = 0 ) 
uniform restrict writeonly image2D outputImage;

layout( push_constant, std430 ) 
uniform Params 
{
  float alphaTreshold;

} params;

void main() 
{
	ivec2 currentPosition  = ivec2( gl_GlobalInvocationID.xy );
	vec4 currentPixel = imageLoad( inputImage, currentPosition );

	if ( currentPixel.a < params.alphaTreshold ) 
  {
		vec4 packedZero = vec4( unpackUnorm2x16( 0 ), unpackUnorm2x16( 0 ) );
		imageStore( outputImage, currentPosition, packedZero );
		return;
	}

	vec4 packedPosition = vec4( unpackUnorm2x16( currentPosition.x ), unpackUnorm2x16( currentPosition.y ) );
	imageStore( outputImage, currentPosition, packedPosition);
}
