#[compute]
#version 450

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout(rgba16, set = 0, binding = 0) 
uniform restrict readonly image2D inputImage;

layout(rgba16, set = 1, binding = 0) 
uniform restrict writeonly image2D outputImage;

layout(std430, set = 2, binding = 0) 
buffer restrict readonly JumpDistanceBuffer { int jump; } jdb;

void main() 
{
	ivec2 currentPosition = ivec2( gl_GlobalInvocationID.xy );
	ivec2 imageSize = imageSize( inputImage );

	float distanceToClosestSeed = 1.0f / 0.0f;
	vec4 closestSeed = vec4( unpackUnorm2x16( 0 ), unpackUnorm2x16( 0 ) );

  ivec2 jdbJump = ivec2( jdb.jump, jdb.jump );

	for ( int x = -1; x <= 1; x++ ) 
  {
		for ( int y = -1; y <= 1; y++ ) 
    {
      ivec2 xy = ivec2( x, y ); 

			ivec2 checkPosition = currentPosition + jdbJump * xy; 

			if ( checkPosition.x < 0 || checkPosition.y < 0 || 
           checkPosition.x >= imageSize.x || checkPosition.y >= imageSize.y ) 
      {
				continue;
			}

			vec4 checkPixel = imageLoad( inputImage, checkPosition );
      float checkSeedX = float( packUnorm2x16( checkPixel.xy ) );
      float checkSeedY = float( packUnorm2x16( checkPixel.zw ) );

			vec2 checkSeedPosition = vec2( checkSeedX, checkSeedY );

			if ( checkSeedPosition.x == 0.0f && checkSeedPosition.y == 0.0f ) 
      {
				continue;
			}

			float distanceToSeed = distance( vec2( currentPosition ), checkSeedPosition );

			if ( distanceToSeed < distanceToClosestSeed ) 
      {
				distanceToClosestSeed = distanceToSeed;
				closestSeed = checkPixel;
			}
		}
	}

	imageStore( outputImage, currentPosition, closestSeed );
}
