
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class VignetteEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "Vignette/VignetteShader.glsl" );

    [ExportGroup("Vignette")]
    [Export( PropertyHint.Range, "0,1")]
    public float amount = 1.0f;

    [Export( PropertyHint.Range, "-1,1")]
    public float fadePosition;

    [Export( PropertyHint.Range, "-2,2")]
    public float fadeInOffset = -0.1f;

    [Export( PropertyHint.Range, "-2,2")]
    public float fadeOutOffset= 0.1f;

    [Export( PropertyHint.Range, "-10,10")]
    public float fadePower= 1f;

    [Export( PropertyHint.Range, "0,1")]
    public float ellipseToCircle= 0.5f;

    [ExportGroup("Colors")]

    [Export]
    public Color colorTop = Colors.Black;

    [Export]
    public Color colorBottom = Colors.Black;
   

    [ExportGroup("Blend Mode")]
    [Export]
    public float replace = 1.0f;

    [Export]
    public float add = 0.0f;

    [Export]
    public float multiply = 0.0f;

    [Export]
    public float colorize = 0.0f;


    [Export]
    public string info = "";

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 8;
    }

    protected override void SetConstants()
    {     
      constants.Set(        
        colorTop.SrgbToLinear(),
        colorBottom.SrgbToLinear(),
        (Vector2) context.internalSize,
        amount,
        fadePosition + fadeInOffset,
        fadePosition + fadeOutOffset,        
        ellipseToCircle,
        Mathf.Pow( 10f, fadePower / 10f ),
        replace,
        add,
        multiply,
        colorize
      );

      info = "constants: " + constants.info;


    }

    public override void ClearCaches()
    {
      base.ClearCaches();
    }

    protected override void RenderView()
    {
      context.AssignScreenColorTexture();

      context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}