
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class CircleWipeEffect:WipeCompositorEffect
  {
    public CircleWipeEffect():base()
    {
      InitializeWipe( new RG_CircleWipe( graph ) );
    }

    [ExportGroup( "Circle" )]
    [Export( PropertyHint.Range, "-1,2")]
    public float centerX = 0.5f;

    [Export( PropertyHint.Range, "-1,2")]
    public float centerY = 0.5f;

    [Export( PropertyHint.Range, "0,0.5")]
    public float fade = 0.1f;

    protected override void ForAllViews()
    {
      SetWipeConstants(
        centerX,
        centerY,
        fade
      );

    }

   
  }
}