
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class DirectionalWipeEffect:WipeCompositorEffect
  {
    public DirectionalWipeEffect():base()
    {
      InitializeWipe( new RG_DirectionalWipe( graph ) );
    }

    [ExportGroup( "Directional" )]
    [Export( PropertyHint.Range, "0,360")]
    public float angle = 0.0f;

    [Export( PropertyHint.Range, "0,0.5")]
    public float fade = 0.1f;

    public enum DirectionType
    {
      Single,
      Double
    }

    [Export( PropertyHint.Range, "0,0.5")]
    public DirectionType directionType = DirectionType.Single;

    protected override void ForAllViews()
    {
      SetWipeConstants(
        angle,
        fade,
        directionType == DirectionType.Single ? 0f : 1f
      );

    }

   
  }
}