
using Godot;
using Godot.Collections;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class NoiseWipeEffect:WipeCompositorEffect
  {
    public NoiseWipeEffect():base()
    {
      InitializeWipe( new RG_NoiseWipe( graph ) );
    }

    [ExportGroup( "Noise" )]
    [Export( PropertyHint.Range, "0,1")]
    public float noiseAmount = 1.0f;

    [Export( PropertyHint.Range, "0.1,100")]
    public float noiseFrequency = 10f;

    [Export]
    public Vector2 noisePosition = Vector2.Zero;

    [Export]
    public Vector2 noiseWipeOffset = Vector2.Zero;

    protected override void ForAllViews()
    {
      var noiseOffset = noisePosition + noiseWipeOffset * GetWipeColor().A;

      SetWipeConstants(
        noiseAmount,
        noiseFrequency,
        noiseOffset.X,
        noiseOffset.Y 
      );

    }

   
  }
}