
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class SingleShaderCompositorEffect:RokojoriCompositorEffect
  {
    protected string _shaderPath;
    
    protected RDShader _shader;
    protected RDPipeline _pipeline;
    protected int _groupSize = 16;

    protected override void OnInitialize()
    {
      context.Verbose( "Trying to load shader: ", _shaderPath );

      if ( _shaderPath == null )
      {
        context.Error( "_shaderPath == null" );
        return;
      }

      var glslFile = GD.Load<RDShaderFile>( _shaderPath );

      if ( glslFile == null )
      {
        context.Error( "Couldn't load shader at path:", _shaderPath );
        return;
      }

      _shader = RDShader.CreateFromSpirV( context, glslFile.GetSpirV() );      

      if ( _shader == null )
      {
        context.Error( "Couldn't create shader from code, path:", _shaderPath );
        return;
      }

      _pipeline = RDPipeline.CreateCompute( context, _shader );

      if ( _shader == null )
      {
        context.Error( "Couldn't create pipeline from compiled shader, path:", _shaderPath );
        return;
      }
      
      context.Verbose( "Created shader at path: ", _shaderPath );

      context.SetShaderAndPipeline( _shader, _pipeline );
    }     

    protected RDPushConstants _constants = new RDPushConstants();
    public RDPushConstants constants => _constants;

    protected override void ForAllViews()
    {     
      context.CalculateSceneComputeGroups( _groupSize );

      SetConstants();
    }

    protected virtual void SetConstants()
    {

    }

    public override void ClearCaches()
    {
      _constants.Clear();
    }
    
  }
}