
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public partial class RDContext
  {
    public RDSampler Sampler( RDSamplerState state = null)
    {
      if ( state == null )
      {
        state = new RDSamplerState();
        state.MinFilter = RenderingDevice.SamplerFilter.Linear;
        state.MagFilter = RenderingDevice.SamplerFilter.Linear;
        state.RepeatU = RenderingDevice.SamplerRepeatMode.Repeat;
        state.RepeatV = RenderingDevice.SamplerRepeatMode.Repeat;
      } 

      var sampler = RDSampler.Create( this, state );
      return sampler;
    }

    public RDSampler Sampler( RenderingDevice.SamplerFilter filter, RenderingDevice.SamplerRepeatMode repeatMode)
    {
      var state = new RDSamplerState();

      state.MinFilter = filter;
      state.MagFilter = filter;

      state.RepeatU = repeatMode;
      state.RepeatV = repeatMode;

      return Sampler( state );
    }

  }
}