
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public partial class RDContext
  {
    protected List<Message> _messages = new List<Message>();
    public List<Message> messages => _messages;
    public bool logMessages = true;
    public int messageLogLevel = Messages.GetLevel( MessageType.Info );

    public bool HasError()
    {
      return Messages.HasError( _messages );
    }  
    

    public void Error( params object[] messages )
    {
      var message = RJLog.GetLogString( messages );

      Messages.Error( _messages, message );

      if ( logMessages )
      {
        RJLog.ErrorWithFullTrace( message );
      }
    }

    public void Warning( params object[] messages )
    {
      var message = RJLog.GetLogString( messages );

      Messages.Warning( _messages, message );

      if ( logMessages && Messages.GetLevel( MessageType.Warning ) >= messageLogLevel )
      {
        RJLog.ErrorWithFullTrace( message );
      }
    }

    public void Info( params object[] messages )
    {
      var message = RJLog.GetLogString( messages );

      Messages.Info( _messages, message );

      if ( logMessages && Messages.GetLevel( MessageType.Info ) >= messageLogLevel )
      {
        RJLog.LogWithTraceOffset( 1, message );
      }
    }

    public void Verbose( params object[] messages )
    {
      var message = RJLog.GetLogString( messages );

      Messages.Verbose( _messages, message );

      if ( logMessages && Messages.GetLevel( MessageType.Verbose ) >= messageLogLevel )
      {
        RJLog.LogWithTraceOffset( 1, message );
      }
    }
    
  }
}