
using Godot;

namespace Rokojori
{  
  public class RDComputeList
  {
    RenderingDevice _rd;
    public RenderingDevice rd => _rd;

    long _computeListID;
    public long id => _computeListID;
    
    public RDComputeList( RenderingDevice rd, long id )
    {
      _rd = rd;
      _computeListID = id;
    }

    public void End()
    {
      rd.ComputeListEnd();
      _computeListID = 0;
      _rd = null;
    }

    public void BindPipeline( RDPipeline pipeline )
    {
      rd.ComputeListBindComputePipeline( _computeListID, pipeline.rid );
    }

    public void BindUniformSet( RDUniformSet uniformSet, int index )
    {
      rd.ComputeListBindUniformSet( _computeListID, uniformSet.rid, (uint) index );
    }

     public void SetPushConstants( RDPushConstants constants )
    {
      var bytes = constants.bytes;
      rd.ComputeListSetPushConstant( _computeListID, bytes, (uint) bytes.Length );
    }

    public void Dispatch( Vector3I groups )
    {
      rd.ComputeListDispatch( _computeListID, (uint)groups.X, (uint)groups.Y, (uint)groups.Z );
    }

    public static RDComputeList Begin( RenderingDevice rd )
    {
      return new RDComputeList( rd, rd.ComputeListBegin() );
    }
  }
}