
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class RDFrameBuffer: RDObject
  {
    public RDFrameBuffer( RDContext context, Rid rid ):base( context, rid )
    {}

    public static RDFrameBuffer Create( RDContext context, List<RDTexture> textures, RDFrameBufferFormat format )
    {
      var RD = context.renderingDevice;
      var rid = RD.FramebufferCreate( textures.Map( t => t.rid ).ToGodotArray(), format.id );

      return new RDFrameBuffer( context, rid );      
    }
  }
}