
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class RDFrameBufferFormat
  {
    RDContext _context;
    long _id;

    public long id => _id;

    public RDFrameBufferFormat( RDContext context, long id ) 
    {
      _context = context;
      _id = id;
    }

    public static RDFrameBufferFormat Create( RDContext context, List<RDAttachmentFormat> formats, int viewCount = 1 )
    {

      var id = context.renderingDevice.FramebufferFormatCreate( formats.ToGodotArray(), (uint)viewCount );

      return new RDFrameBufferFormat( context, id );
    }
  }
}