
using Godot;

namespace Rokojori
{  
  public class RDObject
  {
    protected RDContext _context;
    public RDContext context => _context;

    protected Rid _rid;
    public Rid rid => _rid;

    protected bool _isDestroyed = false;
    public bool valid => ! _isDestroyed && _context != null && _rid.IsValid;

    public RDObject( RDContext context, Rid rid )
    {
      _context = context;
      _rid = rid;

      _context.AddToCleanUp( this, GetType().Name + "@" + _rid );

      context.Verbose( "Creating", GetType().Name, rid );
    }

    public void Free( RDContext context )
    {
      context.renderingDevice.FreeRid( _rid );
      _rid = new Rid();
      _context = null;
      _isDestroyed = true;
    }

  }
}