
using Godot;

namespace Rokojori
{  
  public class RDPipeline: RDObject
  {
    public RDPipeline( RDContext context, Rid rid ):base( context, rid )
    {}

    public static RDPipeline CreateCompute( RDContext context, RDShader shader )
    {
      return new RDPipeline( context, context.renderingDevice.ComputePipelineCreate( shader.rid ) );
    }

     public static RDPipeline CreateRender( RDContext context, RDShader shader, RDRenderPipelineSetup setup  )
    {
      var pipelineRid = context.renderingDevice.RenderPipelineCreate( 
        shader.rid, setup.frameBufferFormat.id, setup.vertexFormat.id,
        setup.primitive, setup.rasterizationState,
        setup.multisampleState,
        setup.stencilState, setup.blendState        
      );

      return new RDPipeline( context, pipelineRid );
    }
  }
}