
using Godot;
using Godot.Collections;

namespace Rokojori
{  
  
  public class RDProgram
  { 
    protected RDContext _context;
    public RDContext context => _context;

    public RDProgram( RDContext context )
    {
      _context = context;
    }

    public enum Type 
    {
      VertexFragment,
      Compute 
    }

    protected Type _type;
    public Type type => _type;

    protected RDShader _shader;
    public RDShader shader => _shader;

    protected RDPipeline _pipeline;
    public RDPipeline pipeline => _pipeline;

    public static RDProgram ComputeFromPath( RDContext context, string path )
    {
      var p = new RDProgram( context );

      p._shader = RDShader.FromPath( context, path );

      if ( p._shader == null || ! p._shader.rid.IsValid )
      {
        context.Error( "Invalid shader", path );
        return null;
      }

      p._pipeline = RDPipeline.CreateCompute( context, p._shader );

       if ( p._pipeline == null || ! p._pipeline.rid.IsValid )
      {
        context.Error( "Invalid pipeline", path );
        return null;
      }

      return p; 
    }
  }

//   public static RDProgram RenderFromPath( RDContext context, string path, RDRenderPipelineSetup setup )
//     {
//       var p = new RDProgram( context );

//       p._shader = RDShader.FromPath( context, path );

//       if ( p._shader == null || ! p._shader.rid.IsValid )
//       {
//         context.Error( "Invalid shader", path );
//         return null;
//       }

//       p._pipeline = RDPipeline.CreateRender( context, p._shader, setup );

//        if ( p._pipeline == null || ! p._pipeline.rid.IsValid )
//       {
//         context.Error( "Invalid pipeline", path );
//         return null;
//       }

//       return p; 
//     }
//   }
// }
}