
using Godot;
using System;
using System.Collections.Generic;

namespace Rokojori
{  
  public class RDRenderPipelineSetup
  { 
    public RDFrameBufferFormat frameBufferFormat;
    public RDVertexFormat vertexFormat;
    
    public RDPipelineRasterizationState rasterizationState;
    public RDPipelineMultisampleState multisampleState;

    public RDPipelineDepthStencilState stencilState;
    public RDPipelineColorBlendState blendState;
    public RenderingDevice.RenderPrimitive primitive;


    public static RDPipelineColorBlendState CreateBlendState()
    {
      var blend = new RDPipelineColorBlendState();
      var blendAttachment = new RDPipelineColorBlendStateAttachment();

      blend.Attachments.Add( blendAttachment );

      return blend;
    }

    public static RDPipelineDepthStencilState CreateStencilState( 
      RenderingDevice.CompareOperator compareOperator, int mask, int reference,
      RenderingDevice.StencilOperation failOperation,  RenderingDevice.StencilOperation passOperation 
    )
    {
      var stencil_state = new RDPipelineDepthStencilState();
      stencil_state.FrontOpCompare = compareOperator;
      stencil_state.FrontOpCompareMask = (uint) mask;
      stencil_state.FrontOpReference =  (uint) reference;
      stencil_state.FrontOpFail = failOperation;
      stencil_state.FrontOpPass = passOperation;

      return stencil_state;
    }
    public static RDRenderPipelineSetup Create( RDFrameBufferFormat fbFormat, RDVertexFormat vxFormat, RDPipelineDepthStencilState stencilState ) 
    {
      var setup = new RDRenderPipelineSetup();
      setup.rasterizationState = new RDPipelineRasterizationState();
      setup.multisampleState = new RDPipelineMultisampleState();
      setup.primitive = RenderingDevice.RenderPrimitive.Triangles;
      setup.blendState = CreateBlendState();
      setup.stencilState = stencilState;
      return setup;
    }
    
  }
}