
using Godot;

namespace Rokojori
{  
  public class RDShader: RDObject
  {
    public RDShader( RDContext context, Rid rid ):base( context, rid )
    {}

    public static RDShader CreateFromSpirV( RDContext context, RDShaderSpirV rDShaderSpirV, string pathInfo = null )
    {
      var shaderID = context.renderingDevice.ShaderCreateFromSpirV( rDShaderSpirV );

      if ( ! shaderID.IsValid )
      {
        context.Error( "Couldn't create shader from spirV. PathInfo:", pathInfo );
        return null;
      }

      return new RDShader( context, shaderID );
    }

    public static RDShader FromPath( RDContext context, string path )
    {
      var glslFile = GD.Load<RDShaderFile>( path );

      if ( glslFile == null )
      {
        context.Error( "File not found:", path );
        return null;
      }

      var spirV = glslFile.GetSpirV();

      if ( spirV == null )
      {
        context.Error( "SpirV is null", path );
        return null;
      }

      return CreateFromSpirV( context, spirV, path );
    }
  }
}