
using Godot;
using Godot.Collections;

namespace Rokojori
{  
  public class RDUniformSet:RDObject
  {
    protected int _setIndex = -1;
    public int setIndex => _setIndex;

    public RDUniformSet( RDContext effect, int setIndex, Rid rid ):base( effect, rid )
    {
      _setIndex =setIndex;
    }
    
    public static RDUniformSet Image( RDContext context, RDTexture texture, int setIndex )
    { 
      var uniform = new RDUniform();
      uniform.UniformType = RenderingDevice.UniformType.Image;
      uniform.Binding = 0;
      uniform.AddId( texture.rid );


      var rid = context._CreateUniformSetRid( setIndex, uniform );
      // UniformSetCacheRD.GetCache( context.shader.rid, (uint) setIndex, new Array<RDUniform> { uniform } );
      // var rid = rd.UniformSetCreate( new Array<RDUniform>{ uniform }, effect.context.shader.rid, (uint) setIndex );

      return new RDUniformSet( context, setIndex, rid );
    } 

    public static RDUniformSet Sampler( RDContext context, RDSampler sampler, RDTexture texture, int setIndex )
    { 
      var uniform = new RDUniform();
      uniform.UniformType = RenderingDevice.UniformType.SamplerWithTexture;
      uniform.Binding = 0;
      uniform.AddId( sampler.rid );
      uniform.AddId( texture.rid ) ;
      
      // var rid = UniformSetCacheRD.GetCache( context.shader.rid, (uint) setIndex, new Array<RDUniform>{ uniform } );
      var rid = context._CreateUniformSetRid( setIndex, uniform );
      // var rid = rd.UniformSetCreate( new Array<RDUniform>{ uniform }, effect.context.shader.rid, (uint) setIndex );

      return new RDUniformSet( context, setIndex, rid );
    } 
  }
}