
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class RDVertexFormat
  {
    RDContext _context;
    long _id;

    public long id => _id;

    public RDVertexFormat( RDContext context, long id ) 
    {
      _context = context;
      _id = id;
    }

    public static RDVertexFormat Create( RDContext context, List<RDVertexAttribute> vertexAttributes )
    {
      var id = context.renderingDevice.VertexFormatCreate( vertexAttributes.ToGodotArray() );
      return new RDVertexFormat( context, id );
    }
  }
}