#[compute]
#version 450

layout( local_size_x = 8, local_size_y = 8, local_size_z = 1 ) in;

layout( rgba16, set = 0, binding = 0 ) 
uniform restrict readonly image2D inputImage;

layout( rgba16, set = 1, binding = 0 ) 
uniform restrict writeonly image2D outputImage;

void main() 
{
  ivec2 imgSize = imageSize( inputImage );
	ivec2 currentPosition = ivec2( gl_GlobalInvocationID.xy );

  if ( any( greaterThanEqual( currentPosition, imgSize ) )  ) 
  {
    return;
  }

	vec4 currentPixel = imageLoad( inputImage, currentPosition ); 

	imageStore( outputImage, currentPosition, currentPixel );
}
