
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class CEG_ImageProcessor:RDShaderProcessor
  {
    public readonly CompositorEffectGraphTextureSlot input;
    public readonly CompositorEffectGraphTextureSlot output;

    public CEG_ImageProcessor( RDGraph graph, string shaderPath ):base( graph, shaderPath )
    {
      input = new CompositorEffectGraphTextureSlot( this );
      output = new CompositorEffectGraphTextureSlot( this );

      _textureSlots.AddRange( new List<CompositorEffectGraphTextureSlot>{ input, output } );
    } 

    public void SetTextureSlotInputs( RDGraphTextureSlotInput inputSlot, RDGraphTextureSlotInput outputSlot )
    {
      inputSlot.ConnectTo( input );
      outputSlot.ConnectTo( output );
    }

    public void SetTextureSlotInputs( CEG_ImageProcessor imageProcessorBefore )
    {
      imageProcessorBefore.input.ConnectTo( input );
      imageProcessorBefore.output.ConnectTo( output );
    }

    public void AddTextureSlotInput( RDGraphTextureSlotInput inputSlot )
    {
      var slot = new CompositorEffectGraphTextureSlot( this );
      _textureSlots.Add( slot );

      inputSlot.ConnectTo( slot );
    }

    
  }
}