
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class CEG_ScreenColorTexure:RGGraphProcessor, RDGraphTextureSlotInput
  {
    RDTexture _texture;

    public RDTexture GetTexture()
    {
      return _texture;
    }

    public RGGraphProcessor GetProcessor()
    {
      return this;
    } 

    List<CompositorEffectGraphTextureSlot> _connectedSlots = new List<CompositorEffectGraphTextureSlot>();

    public void SetConnected( CompositorEffectGraphTextureSlot slot )
    {
      _connectedSlots.Add( slot );
    }

    public CEG_ScreenColorTexure( RDGraph graph ):base( graph )
    {} 

    public override void Process()
    {
      _texture = graph.context.GetScreenColorTexture();
    }

    public void ConnectTo( CompositorEffectGraphTextureSlot slot )
    {
      slot.SetInput( this );
    }
    
  }
}