
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class RG_ImageTexture:RGGraphProcessor, RDGraphTextureSlotInput
  {
    RDTexture _texture;

    public RDTexture GetTexture()
    {
      return _texture;
    }

    public RGGraphProcessor GetProcessor()
    {
      return this;
    } 

    List<CompositorEffectGraphTextureSlot> _connectedSlots = new List<CompositorEffectGraphTextureSlot>();

    public void SetConnected( CompositorEffectGraphTextureSlot slot )
    {
      _connectedSlots.Add( slot );
    }

    public RG_ImageTexture( RDGraph graph):base( graph )
    {

    } 

    public void SetImageTexture( RDTexture texture )
    {
      _texture = texture;
    }

    public override void Process()
    {

    }

    public void ConnectTo( CompositorEffectGraphTextureSlot slot )
    {
      slot.SetInput( this );
    }
    
  }
}