#[compute]
#version 450

layout( local_size_x = 8, local_size_y = 8, local_size_z = 1 ) in;

layout( rgba16, set = 0, binding = 0 ) 
uniform restrict readonly image2D inputImage;

layout( rgba16, set = 1, binding = 0 ) 
uniform restrict writeonly image2D outputImage;

layout( rgba16, set = 2, binding = 0 ) 
uniform restrict readonly image2D originalImage;

void main()  
{ 
	ivec2 currentPosition = ivec2( gl_GlobalInvocationID.xy );
	vec4 currentPixel     = imageLoad( inputImage, currentPosition );

	ivec2 seedPosition = ivec2( packUnorm2x16( currentPixel.xy ), packUnorm2x16( currentPixel.zw ) );

	vec4 colorPixel    = imageLoad( originalImage, seedPosition );
  vec4 originalPixel = imageLoad( originalImage, currentPosition );

  vec2 seedUV = vec2( seedPosition ) / imageSize( inputImage );

	imageStore( outputImage, currentPosition, vec4( colorPixel.rgb, originalPixel.a) );
}
