
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class RDGraph
  {
    public RDGraph( RDContext context )
    {
      _context = context;
    }

    protected RDContext _context;
    public RDContext context => _context;
    public static readonly string path = "res://addons/rokojori_action_library/Runtime/Rendering/RenderGraph";
    public static string Path( string subPath )
    {
      return path + "/" + subPath;
    }

    protected List<RDGraphNode> _nodes = new List<RDGraphNode>();
    protected List<RGGraphProcessor> _processors = new List<RGGraphProcessor>();
    protected List<RGGraphProcessor> _processOrder = new List<RGGraphProcessor>();


    public void Register( RDGraphNode node )
    {
      _nodes.Add( node );

      if ( node is RGGraphProcessor p )
      {
        _processors.Add( p );
      }
    }
    
    public void InitializeNodes()
    {
      _processors.ForEach( p => p.Initialize() );
    }

    public void SetProcessOrder( List<RGGraphProcessor> order )
    {
      _processOrder.Clear();
      _processOrder.AddRange( order );
    }

    public void SetProcessOrder( params RGGraphProcessor[] order )
    {
      _processOrder.Clear();
      _processOrder.AddRange( order );
    }

    public void ProcessForView()
    {
      
      var index = 1;
      var num = _processOrder.Count;

      _processOrder.ForEach( 
        p => 
        { 
          context.Verbose( index + "/" + num, p.GetType() );
          p.Process();
          index++;
        }
      );

      context.Verbose( "Render done" );

    }
  }
}