
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public interface RDGraphTextureSlotInput
  {
    public RDTexture GetTexture();
    public RGGraphProcessor GetProcessor();
    public void SetConnected( CompositorEffectGraphTextureSlot slot );
    public void ConnectTo( CompositorEffectGraphTextureSlot slot );
  }

  public class CompositorEffectGraphTextureSlot:RDGraphConnection, RDGraphTextureSlotInput
  {
    protected RDGraphTextureSlotInput _input;
    public RDGraphTextureSlotInput input => _input;

    public RDSampler sampler;

    protected RDTexture _texture;
    
    public RDTexture GetTexture()
    {
      return _texture;
    }

    public RDTexture ResolveTexture()
    {
      return _texture = _input.GetTexture();
    }

    public RGGraphProcessor GetProcessor()
    {
      return _processor;
    }

    List<CompositorEffectGraphTextureSlot> _connectedSlots = new List<CompositorEffectGraphTextureSlot>();

    public void SetConnected( CompositorEffectGraphTextureSlot slot )
    {
      _connectedSlots.Add( slot );
    }

    public CompositorEffectGraphTextureSlot( RGGraphProcessor processor ):base( processor )
    {

    }

    public void SetInput( RDGraphTextureSlotInput input )
    {
      _input = input;
      input.SetConnected( this );
    }

    public void ConnectTo( CompositorEffectGraphTextureSlot slot )
    {
      slot.SetInput( this );
    }
  }

  public class RG_TextureSlotEditable:CompositorEffectGraphTextureSlot
  {
    public RG_TextureSlotEditable( RGGraphProcessor processor ):base( processor ){}

    public void SetTexture( RDTexture texture )
    {
      _texture = texture;
    }
  }
}