
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class RenderingManagerData:Resource
  {   
    [Export]
    public RenderingPriority[] renderingPriorities = [];
    
    [Export]
    public StencilLayer[] stencilLayers = [];

    [Export]
    public ShaderPropertyBlock[] globalShaderPropertyBlocks = [];

    [Export]
    public ShaderProperty[] globalShaderProperties = [];   

    public ShaderProperty GetGlobalPropertyByName( ShaderPropertyName name )
    {
      var numProps = numGlobalShaderProperties;
      for ( int i = 0; i < numProps; i++ )
      {
        var p = GetGlobalShaderPropertyAt( i );

        if ( p != null && p.GetPropertyName() == name )
        {
          return p;
        }
        
      }

      return null;
    }

    public int numGlobalShaderProperties
    {
      get 
      {
        var num = 0;


        globalShaderPropertyBlocks.ForEach( b => num += b.shaderProperties.Length );

        num += globalShaderProperties.Length;
        return num;
      }
    }

    public ShaderProperty GetGlobalShaderPropertyAt( int index )
    {
      var offset = 0;

      for ( int i = 0; i < globalShaderPropertyBlocks.Length; i++ )
      {
        if ( globalShaderPropertyBlocks[ i ] == null )
        {
          continue;
        }
        var blockLength = globalShaderPropertyBlocks[ i ].shaderProperties.Length;

        if ( offset <= index & index < offset + blockLength )
        {
          return globalShaderPropertyBlocks[ i ].shaderProperties[ index - offset ];
        }

        offset += blockLength;
      }

      return globalShaderProperties[ index - offset ];
    }
  }
}