
using Godot;
using Rokojori;
using System.Collections.Generic;
using System.Reflection.Emit;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class SetTextureAttributeChannel:Action
  {
    [Export]
    public TextureAttributes textureAttributes;

    [Export]
    public int index = 0;

    [Export]
    public float value = 1;

    [Export]
    public TextureAttributes.Channel channel = TextureAttributes.Channel.Red;

    [Export]
    public TextureAttributes.OperatorType operatorType = TextureAttributes.OperatorType.Set;

    protected override void _OnTrigger()
    {
      

      var ta = textureAttributes;

      if ( ta == null )
      {
        ta = Unique<TextureAttributes>.Get();
      }

      if ( ta == null )
      {
        // this.LogInfo( "No attributes found..." );
        return;
      }

      // this.LogInfo( "Index", index, "Value:", value, "Channel:", channel, "Operator:", operatorType );
      ta.SetChannel( index, value, channel, operatorType );
    }
  }
}