using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;
using System.Linq;



namespace Rokojori
{
  /** <summary for="class SceneReference">
      
      <title>
        A resource to reference scenes safely by path.
      </title>
      
      <description>              
        When the path is assigned, it will be updated, when the path moves.
      </description>

    </summary>  
  */

  [Tool]
  [GlobalClass ]
  public partial class SceneReference:Resource
  {
    [Export(PropertyHint.File, "*.tscn,*.gltf,*.glb,*.fbx,*.obj,*.dae")]
    public string scenePath;

    public PackedScene LoadScene() => scenePath == null || scenePath == "" ? null : GD.Load<PackedScene>( scenePath );
  }
}