using System.Collections.Generic;
using Godot;
using Godot.Collections;

namespace Rokojori
{

  public class SerializedBase
  {
    // TYPE
    public string t;
    public List<MemberData> m = [];


    public static bool isInteral( int usage )
    {
      return ( usage & (int) PropertyUsageFlags.ScriptVariable ) == 0 &&
             ( usage & (int) PropertyUsageFlags.Storage ) == 0 ;
    }

    
    public void Serialize( GodotObject obj )
    {

      var script = (Script)obj.GetScript();

      if ( script != null )
      {
        RJLog.Log( script );
        this.t = ResourceLoader.GetResourceUid( script.ResourcePath ) + "";
      } 
      else
      {
        this.t = obj.GetClass();
      }

      

      Array<Dictionary> propertyList = obj.GetPropertyList();

      foreach ( Dictionary prop in propertyList )
      {
        if ( ! ( prop.ContainsKey( "name" ) && prop.ContainsKey( "usage" ) ) )
        {
          continue;
        }

        var name = prop[ "name" ].AsString();

        var usage = (int) prop[ "usage" ];

        if ( isInteral( usage ) )
        {
          continue;
        }

        var value = obj.Get( name );

        var member = new MemberData();
        member.m = name + " " + value.VariantType.ToString();
        member.v = value.ToString();

        m.Add( member );
      }
      
      
    }
  }

}